/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.shadows;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.nio.IntBuffer;
import java.util.Arrays;
import net.coderbot.iris.gl.framebuffer.GlFramebuffer;
import net.coderbot.iris.gl.texture.DepthBufferFormat;
import net.coderbot.iris.gl.texture.DepthCopyStrategy;
import net.coderbot.iris.gl.texture.InternalTextureFormat;
import net.coderbot.iris.gl.texture.PixelFormat;
import net.coderbot.iris.gl.texture.PixelType;
import net.coderbot.iris.rendertarget.DepthTexture;
import org.lwjgl.opengl.GL;

public class ShadowRenderTargets {
    public static int MAX_SHADOW_RENDER_TARGETS = 8;
    private final int[] targets;
    private final InternalTextureFormat[] formats;
    private final DepthTexture depthTexture;
    private final DepthTexture noTranslucents;
    private final GlFramebuffer framebuffer;
    private final GlFramebuffer noTranslucentFB;
    private final int resolution;
    private static final IntBuffer NULL_BUFFER = null;
    private boolean firstTranslucentCopy;
    private static final boolean supportsFramebufferBlitting = GL.getCapabilities().OpenGL30 || GL.getCapabilities().GL_EXT_framebuffer_blit;

    public ShadowRenderTargets(int n, InternalTextureFormat[] internalTextureFormatArray) {
        if (internalTextureFormatArray.length > MAX_SHADOW_RENDER_TARGETS) {
            throw new IllegalStateException("Too many shadow render targets, requested " + internalTextureFormatArray.length + " but only " + MAX_SHADOW_RENDER_TARGETS + " are allowed.");
        }
        this.formats = Arrays.copyOf(internalTextureFormatArray, internalTextureFormatArray.length);
        this.resolution = n;
        int[] nArray = new int[internalTextureFormatArray.length];
        this.targets = new int[internalTextureFormatArray.length];
        GlStateManager._genTextures((int[])this.targets);
        this.depthTexture = new DepthTexture(n, n, DepthBufferFormat.DEPTH);
        this.noTranslucents = new DepthTexture(n, n, DepthBufferFormat.DEPTH);
        this.framebuffer = new GlFramebuffer();
        this.noTranslucentFB = new GlFramebuffer();
        this.framebuffer.addDepthAttachment(this.depthTexture.getTextureId());
        this.noTranslucentFB.addDepthAttachment(this.noTranslucents.getTextureId());
        for (int i = 0; i < internalTextureFormatArray.length; ++i) {
            InternalTextureFormat internalTextureFormat = internalTextureFormatArray[i];
            RenderSystem.bindTexture((int)this.targets[i]);
            GlStateManager._texImage2D((int)3553, (int)0, (int)internalTextureFormat.getGlFormat(), (int)n, (int)n, (int)0, (int)PixelFormat.RGBA.getGlFormat(), (int)PixelType.UNSIGNED_BYTE.getGlFormat(), (IntBuffer)NULL_BUFFER);
            RenderSystem.texParameter((int)3553, (int)10241, (int)9729);
            RenderSystem.texParameter((int)3553, (int)10240, (int)9729);
            RenderSystem.texParameter((int)3553, (int)10242, (int)33071);
            RenderSystem.texParameter((int)3553, (int)10243, (int)33071);
            this.framebuffer.addColorAttachment(i, this.targets[i]);
            this.noTranslucentFB.addColorAttachment(i, this.targets[i]);
            nArray[i] = i;
        }
        this.framebuffer.drawBuffers(nArray);
        this.noTranslucentFB.drawBuffers(nArray);
        this.firstTranslucentCopy = true;
        RenderSystem.bindTexture((int)0);
    }

    public void copyPreTranslucentDepth() {
        if (this.firstTranslucentCopy && supportsFramebufferBlitting) {
            this.firstTranslucentCopy = false;
            this.framebuffer.bindAsReadBuffer();
            this.noTranslucentFB.bindAsDrawBuffer();
            GlStateManager._glBlitFrameBuffer((int)0, (int)0, (int)this.resolution, (int)this.resolution, (int)0, (int)0, (int)this.resolution, (int)this.resolution, (int)256, (int)9728);
        } else {
            DepthCopyStrategy.fastest(false).copy(this.framebuffer, this.depthTexture.getTextureId(), null, this.noTranslucents.getTextureId(), this.resolution, this.resolution);
        }
    }

    public GlFramebuffer getFramebuffer() {
        return this.framebuffer;
    }

    public DepthTexture getDepthTexture() {
        return this.depthTexture;
    }

    public DepthTexture getDepthTextureNoTranslucents() {
        return this.noTranslucents;
    }

    public int getNumColorTextures() {
        return this.targets.length;
    }

    public int getColorTextureId(int n) {
        return this.targets[n];
    }

    public InternalTextureFormat getColorTextureFormat(int n) {
        return this.formats[n];
    }

    public void destroy() {
        this.framebuffer.destroy();
        GlStateManager._deleteTextures((int[])this.targets);
        this.depthTexture.destroy();
        this.noTranslucents.destroy();
    }
}

